( function( $ ) {

  'use strict';

  $( document ).ready( function() {
    themerainAjax();
    themerainAos();
    themerainHeader();
    themerainHero();
    themerainPortfolio();
    themerainFancybox();
  } );

  $( window ).load( function() {
    $( 'html' ).removeClass( 'is-animating' );
  } );

  if ( themerain.enable_ajax == 1 ) {
    let containers = ['#swup'];

    if ( $( '#wpadminbar' ).length ) {
      containers = ['#swup', '#wpadminbar'];
    }

    const swup = new Swup({
      containers: containers,
      cache: false,
      animateHistoryBrowsing: true,
      plugins: [
        new SwupBodyClassPlugin(),
        new SwupHeadPlugin(),
        new SwupScrollPlugin({
          animateScroll: false
        })
      ]
    })
    .on('contentReplaced', swupReload);
  } else {
    $( document ).on( 'click', 'a:not([target="_blank"]):not([href*=\\#]):not([href^=mailto]):not(a[href$="jpg"]):not([href$="jpeg"]):not(a[href$="gif"]):not(a[href$="png"])', function() {
      $( 'html' ).addClass( 'is-animating' );
    } );
  }

  function swupReload() {
    themerainAjax();
    themerainAos();
    themerainHeader();
    themerainHero();
    themerainPortfolio();
    themerainFancybox();

    // Init Contact Form 7
    if ( $( '.wpcf7-form' ).length > 0 ) {
      wpcf7.initForm( $( '.wpcf7-form' ) );
    }

    // Init ThemeRain Slider block
    if ( $( '.tr-block-slider' ).length > 0 ) {
      $( '.tr-block-slider' ).each( function() {
        $( this ).themerainBlockSlider();
      } );
    }

    // Init Elementor frontend
    if (typeof window.elementorFrontend !== 'undefined') {
      elementorFrontend.init();
    }
  }

  function themerainAjax() {
    // Load more
    function loadMore() {
      $( document ).on( 'click', '.load-more', function() {
        if ( ! $( this ).hasClass( 'loading' ) ) {
          var type = $( this ).attr( 'data-type' );
          var ppp = $( this ).attr( 'data-ppp' );
          var cpage = $( this ).attr( 'data-cpage' );
          var pages = $( this ).attr( 'data-pages' );
          var style = $( this ).attr( 'data-style' );

          $( this ).addClass( 'loading' );

          $.ajax( {
            type : "POST",
            url : themerain.ajaxurl,
            data : {
              action : 'themerain_loadmore',
              type : type,
              ppp : ppp,
              cpage : cpage,
              pages : pages,
              style : style
            },
            success : function( data ) {
              if ( data ) {
                var elem = $( data );

                if ( type === 'post' ) {
                  $( '.blog-area' ).append( elem );
                } else if ( type === 'project' ) {
                  $( '.portfolio-area' ).append( elem );
                }

                themerainAos();

                cpage++;
                $( '.load-more' ).attr( 'data-cpage', cpage );
                $( '.load-more' ).removeClass( 'loading' );

                if ( cpage == pages ) {
                  $( '.load-more' ).hide();
                }
              } else {
                $( '.load-more' ).hide();
              }
            }
          } );
        }
      } );
    }
    loadMore();
  }

  function themerainAos() {
    var controller = new ScrollMagic.Controller();

//     $( '.entry-header, .entry-content > *, .blog-area > *, .portfolio-area.grid > *, .portfolio-area.covers .project-caption, .blocks-gallery-grid > *, .wp-block-column, .next-post, .load-more, .post-footer, .comment, .comment-respond' ).each( function() {
        $( '.entry-header, .blog-area > *, .portfolio-area.grid > *, .portfolio-area.covers .project-caption, .blocks-gallery-grid > *, .wp-block-column, .next-post, .load-more, .post-footer, .comment, .comment-respond' ).each( function() {
      var element = $( this );
      var elementHeight = $( this ).height();

      var scene = new ScrollMagic.Scene( {
        triggerElement: element[0],
        duration: elementHeight,
        triggerHook: 1
      } )
      .on( 'enter', function() {
        element.addClass( 'active' );
      } )
      .addTo( controller );
    } );
  }

  function themerainHeader() {
    // Sticky header
    var headerClass = document.querySelector('.site-header');

    var headroom = new Headroom(headerClass, {
      offset: 200,
      tolerance: 5
    });
    headroom.init();

    // Header color
    function headerColor() {
      if ( $( '.site-hero' ).length > 0 ) {
        var hero = $( '.site-hero' );
        var heroHeight = hero.outerHeight( true );
        var controller = new ScrollMagic.Controller();

        new ScrollMagic.Scene( {
          triggerElement: '.site-hero',
          duration: heroHeight,
          triggerHook: 'onLeave',
          reverse: true,
          offset: -50
        } )
        .setClassToggle( '.site-header', 'header--colored' )
        .addTo( controller );
      }
    }
    headerColor();

    // Desktop menu
    function desktopMenu() {
      var viewportWidth = $( window ).width();

      if ( viewportWidth > 1024 ) {
        $( '.site-menu > ul > .menu-item-has-children' ).each( function() {
          var menuItem = $( this ).find( '.sub-menu' ).children( 'li' );

          $( this ).mouseenter( function() {
            var tl = new TimelineLite();

            $( '.site-menu > ul > li' ).addClass( 'hidden' );
            $( this ).removeClass( 'hidden' );
            tl.staggerTo( menuItem, 0.2, { duration: 0.2, x: 0, opacity: 1 }, 0.1 );
          } ).mouseleave( function() {
            var tl = new TimelineLite();

            $( '.site-menu > ul > li' ).removeClass( 'hidden' );
            tl.staggerTo( menuItem, 0.2, { duration: 0.2, x: -10, opacity: 0 }, 0.1 );
          } );
        } );
      }
    }
    desktopMenu();

    // Mobile menu
    function mobileMenu( menu ) {
      menu.find( '.menu-item-has-children > a' ).after( '<span class="dropdown-toggle"></span>' );
      menu.find( '.current-menu-ancestor > .dropdown-toggle' ).addClass( 'toggle-on' );
      menu.find( '.current-menu-ancestor > .sub-menu' ).addClass( 'toggled-on' );
      menu.find( '.dropdown-toggle' ).click( function() {
        $( this ).toggleClass( 'toggle-on' );
        $( this ).next( '.children, .sub-menu' ).slideToggle( 'toggled-on' );
      } );
    }
    mobileMenu( $( '.site-menu' ) );

    // Menu toggle
    $( '.menu-toggle' ).on( 'click', function() {
      $( 'body' ).toggleClass( 'toggled-on' );
    } );

    $( window ).resize( function() {
      headerColor();
    } );
  }

  function themerainHero() {
    var controller = new ScrollMagic.Controller();

    if ( $( '.site-hero' ).hasClass( 'style-fixed' ) ) {
      var mediaScene = new ScrollMagic.Scene( {
        offset: 100
      } )
      .setClassToggle( '.site-hero', 'has-scrolled' )
      .addTo( controller );
    }

    if ( $( '.site-hero' ).hasClass( 'parallax-img' ) ) {
      var mediaTween = TweenMax.to( '.hero-media img', 1, { y: '20%', ease: Linear.easeNone } );

      var mediaScene = new ScrollMagic.Scene( {
        triggerElement: '.site-hero',
        triggerHook: 0,
        duration: '100%'
      } )
      .setTween( mediaTween )
      .addTo( controller );
    }

    if ( $( '.site-hero' ).hasClass( 'parallax-title' ) ) {
      var captionTween = TweenMax.to( '.hero-caption', 0.5, { y: '35%', ease: Linear.easeNone } );

      var captionScene = new ScrollMagic.Scene( {
        triggerElement: '.site-hero',
        triggerHook: 0,
        duration: '100%'
      } )
      .setTween( captionTween )
      .addTo( controller );
    }
  }

  function themerainPortfolio() {
    // Slider style
    var swiperSlider = new Swiper( '.portfolio-area.slider .swiper-container', {
      slidesPerView: 1,
      speed: 900,
      parallax: true,
      grabCursor: true,
      slideToClickedSlide: true,
      mousewheel: true,
      keyboard: {
        enabled: true
      },
      navigation: {
        nextEl: '.swiper-next'
      },
      on: {
        init: function () {						
          $('.swiper-slide-active').find('video').each(function() {
            $(this).get(0).play();
          });
        },
        slideChangeTransitionStart: function () {
          $('.swiper-slide-active').find('video').each(function() {
            $(this).get(0).play();
          });
        },
        slideChangeTransitionEnd: function () {
          $('.swiper-slide-prev').find('video').each(function() {
            $(this).get(0).pause();
          });
          $('.swiper-slide-next').find('video').each(function() {
            $(this).get(0).pause();
          });
        }
      }
    } );

    // Carousel style
    var swiperCarousel = new Swiper ( '.portfolio-area.carousel .swiper-container', {
      slidesPerView: 1,
      grabCursor: true,
      spaceBetween: 0,
      keyboard: {
        enabled: true
      },
      scrollbar: {
        el: '.swiper-scrollbar',
        draggable: true,
      },
      breakpoints: {
        600: {
          slidesPerView: 2
        },
        1024: {
          slidesPerView: 3
        }
      }
    } );

    // Covers style
    $( '.portfolio-area.covers .project-caption' ).on( 'mouseenter',function() {
      $( this ).parent().addClass( 'hovered' );
      $( '.project-caption' ).addClass( 'hidden' );
      $( this ).removeClass( 'hidden' );
    } ).on( 'mouseleave',function() {
      $( this ).parent().removeClass( 'hovered' );
      $( '.project-caption' ).removeClass( 'hidden' );
    } );

    // Slider caption hover
    $( 'body' ).on( 'mouseenter', '.portfolio-area.slider .project-caption h3 a', function() {
      $('.project-caption').removeClass('hovered');
      $(this).parent().parent().addClass('hovered');
    } ).on( 'mouseleave', '.portfolio-area.slider .project-caption h3 a', function() {
      $('.project-caption').removeClass('hovered');
    } );

    // Video hover
    $( 'body' ).on( 'mouseenter', '.portfolio-area .has-video', function() {
      if ( $( this ).find( 'video' ).length > 0 ) {
        var video = $( this ).find( 'video' );
        $( video )[0].play();
      }
    } ).on( 'mouseleave', '.portfolio-area .has-video', function() {
      if ( $( this ).find( 'video' ).length > 0 ) {
        var video = $( this ).find( 'video' );
        $( video )[0].pause();
        $( video )[0].currentTime = 0;
      }
    } );
  }

  function themerainFancybox() {
    $( '.entry-content' ).find( 'img' ).parent( 'a[href]' ).each( function() {
      if ( $( this ).attr( 'href' ).match( /\.(jpg|jpeg|png|gif)$/ ) ) {
        $( this ).addClass( 'fancybox' );
        $( this ).attr( 'data-no-swup', '' );
      }
    } );

    $( '.entry-content' ).find( '.wp-block-gallery' ).each( function() {
      if ( $( this ).find( 'img' ).parent( 'a' ).hasClass( 'fancybox' ) ) {
        $( this ).find( 'img' ).parent( 'a' ).attr( 'data-fancybox', 'gallery' );
      }
    } );

    $( '.fancybox' ).fancybox( {
      infobar : false,
      transitionEffect : "slide",
      hash: false,
      buttons : [
        'close'
      ]
    } );
  }

} )( jQuery );
