<?php
$style = get_query_var( 'portfolio_style' );
$second_thumb = themerain_meta( 'project_thumbnail_secondary' );
$video = themerain_meta( 'project_thumbnail_video' );
$project_class = ( $video && $style !== 'slider' ) ? ' has-video' : ( ( $second_thumb ) ? ' has-secondary-thumbnail' : '' );

$link_type = themerain_meta( 'project_link_type' );
$link_class = '';
$link_data = '';
$project_href = get_the_permalink();

if ( $link_type === 'image' ) {
	$link_class = ' class="fancybox fancybox-group"';
	$link_data = ' data-no-swup';
	$project_href = wp_get_attachment_url( themerain_meta( 'project_link_image' ) );
} elseif ( $link_type === 'video' ) {
	$link_class = ' class="fancybox"';
	$link_data = ' data-no-swup';
	$project_href = themerain_meta( 'project_link_video' );
} elseif ( $link_type === 'url' ) {
	$project_href = themerain_meta( 'project_link_url' );
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( esc_attr( $project_class ) ); ?>>
	<div class="project-thumbnail">
		<div class="project-thumbnail-inner"<?php if ( 'slider' === $style ) echo 'data-swiper-parallax="25%"'; ?>>
			<?php if ( $video ) { ?>

				<video class="lazyload" src="<?php echo wp_get_attachment_url( $video ); ?>" data-poster="<?php echo get_the_post_thumbnail_url(); ?>" preload="none" muted loop playsinline>

			<?php } elseif ( has_post_thumbnail() ) { ?>

				<?php echo themerain_get_image( get_post_thumbnail_id() ); ?>

				<?php if ( $second_thumb ) { ?>
					<div class="project-thumbnail-secondary">
						<?php echo themerain_get_image( $second_thumb ); ?>
					</div>
				<?php } ?>

			<?php } ?>
		</div>
	</div>

	<div class="project-caption">
		<?php
		if ( $link_type === 'none' ) {
			the_title( '<h3' . ( 'slider' === $style ? ' data-swiper-parallax="20%"' : '' ) . '><span>', '</span></h3>' );
		} else {
			the_title( '<h3' . ( 'slider' === $style ? ' data-swiper-parallax="20%"' : '' ) . '><a href="' . esc_url( $project_href ) . '"' . $link_class . $link_data . '><span>', '</span></a></h3>' );
		}

		if ( has_excerpt() ) the_excerpt();
		?>
	</div>
</article>
