<?php
if ( themerain_meta( 'hero_hide_title' ) ) {
  return;
}

$title = get_the_title();
if ( is_home() && ! is_front_page() ) {
	$title = get_the_title( get_option( 'page_for_posts' ) );
}

$custom_title = themerain_meta( 'hero_title' );
$hero_title = ( $custom_title ) ? $custom_title : $title;
$hero_subtitle = themerain_meta( 'hero_subtitle' );
?>

<div class="hero-caption">
  <h1 class="hero-title"><?php echo nl2br( wp_kses_post( $hero_title ) ); ?></h1>

  <?php if ( $hero_subtitle ) { ?>
    <p class="hero-subtitle"><?php echo nl2br( wp_kses_post( $hero_subtitle ) ); ?></p>
  <?php } ?>
</div>
