<?php

/**
 * Class to register custom Gutenberg blocks.
 */
final class ThemeRain_Blocks {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'front_scripts' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
	}

	/**
	 * Enqueue assets for frontend only.
	 */
	public function front_scripts() {
		wp_enqueue_script( 'themerain-blocks-front', plugins_url( 'js/blocks-front.js', __FILE__ ), array( 'jquery' ), '1.0.0', true );
	}

	/**
	 * Enqueue assets for backend only.
	 */
	public function admin_scripts() {
		// Styles
		wp_enqueue_style( 'swiper', plugins_url( 'css/swiper.min.css', __FILE__ ) );
		wp_enqueue_style( 'themerain-blocks-admin', plugins_url( 'css/blocks-admin.css', __FILE__ ), array( 'wp-editor' ) );

		// Scripts
		wp_enqueue_script( 'themerain-blocks-admin', plugins_url( 'js/blocks-admin.js', __FILE__ ), array( 'wp-element', 'wp-blocks', 'wp-editor', 'wp-components' ), '1.0.0', true );
	}
}

new ThemeRain_Blocks();
