<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * ThemeRain Fonts
 */
final class ThemeRain_Fonts {

	private static $instance = null;

	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'render_google_fonts' ) );
	}

	public static function get_fonts() {
		$fonts = apply_filters( 'themerain_fonts', array() );
		$fonts_array = array();

		if ( empty( $fonts ) ) {
			return;
		}

		foreach ( $fonts as $font ) {
			$name = explode( ':', $font )[0];

			$fonts_array["{$font}"] = $name;
		}

		return $fonts_array;
	}

	public static function get_all_fonts() {
		$fonts = array();
		$custom_fonts = self::get_custom_fonts();
		$adobe_fonts = self::get_adobe_fonts();

		if ( ! empty( $custom_fonts ) ) {
			$fonts['Custom Fonts'] = $custom_fonts;
		}

		if ( ! empty( $adobe_fonts ) ) {
			$fonts['Adobe Fonts'] = $adobe_fonts;
		}

		$fonts['Google Fonts'] = self::get_google_fonts();

		return $fonts;
	}

	public static function get_custom_fonts() {
		$fonts = array();
		$get_fonts = array();

		if ( class_exists( 'Bsf_Custom_Fonts_Taxonomy' ) ) {
			$get_fonts = Bsf_Custom_Fonts_Taxonomy::get_fonts();
		}

		if ( ! empty( $get_fonts ) ) {
			foreach ( $get_fonts as $font => $link ) {
				$fonts["{$font}"] = $font;
			}
		}

		return $fonts;
	}

	public static function get_adobe_fonts() {
		if ( ! class_exists( 'Custom_Typekit_Fonts' ) ) {
			return;
		}

		$get_fonts = get_option( 'custom-typekit-fonts' );
		$get_fonts = $get_fonts['custom-typekit-font-details'];

		if ( empty( $get_fonts ) ) {
			return;
		}

		foreach ( $get_fonts as $font ) {
			$family = $font['family'];
			$variants = implode( ',', $font['weights'] );
			$fonts["{$family}:{$variants}"] = $family;
		}

		return $fonts;
	}

	public static function get_google_fonts() {
		$get_fonts = json_decode( file_get_contents( plugin_dir_path( __FILE__ ) . 'google-fonts.json' ), true );

		foreach ( $get_fonts['items'] as $font ) {
			$family = $font['family'];
			$variants = array_diff( $font['variants'], array( '100', '100italic', '200', '200italic', '300', '300italic', '500', '500italic', '800', '800italic', '900', '900italic' ) );
			$variants = implode( ',', $variants );
			$fonts["{$family}:{$variants}"] = $family;
		}

		return $fonts;
	}

	public static function render_google_fonts() {
		$fonts = self::get_fonts();
		$google_fonts = self::get_google_fonts();

		if ( ! is_array( $fonts ) ) {
			return;
		}

		$new_array = array_intersect( $fonts, $google_fonts );

		$google_font_url = self::google_fonts_url( $new_array );

		wp_enqueue_style( 'themerain-google-fonts', $google_font_url, null );
	}

	public static function google_fonts_url( $fonts = array() ) {
		$font_families = array();

		foreach ( $fonts as $font => $name ) {
			$font_families[] = $font;
		}

		if ( ! empty( $font_families ) ) {

			$query_args = array(
				'family'  => urlencode( implode( '|', array_unique( $font_families ) ) ),
				'subset'  => urlencode( 'latin,latin-ext' ),
				'display' => urlencode( 'swap' )
			);

			return add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
		}

		return '';
	}
}

ThemeRain_Fonts::get_instance();
