<?php

/**
 * Class to register meta boxes.
 */
class ThemeRain_Meta_Boxes {

	/**
	 * Constructor.
	 */
	public function __construct() {

		// Add meta boxes
		add_action( 'init', array( $this, 'add' ) );

		// Register styles and scripts
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue' ) );
	}

	/**
	 * Enqueue styles and scripts.
	 */
	public function enqueue() {

		// Styles
		wp_enqueue_style( 'themerain-meta-boxes', plugins_url( 'assets/css/main.css', __FILE__ ) );
		wp_enqueue_style( 'wp-color-picker' );

		// Scripts
		wp_enqueue_script( 'themerain-meta-boxes', plugins_url( 'assets/js/main.js', __FILE__ ), array( 'jquery', 'wp-color-picker' ), false, true );
	}

	/**
	 * Add meta boxes.
	 */
	public function add() {

		if ( ! is_admin() ) {
			return;
		}

		$meta_boxes = apply_filters( 'themerain_meta_boxes', array() );

		if ( ! is_array( $meta_boxes ) ) {
			return;
		}

		foreach( $meta_boxes as $meta_box ) {
			new ThemeRain_Meta_Box( $meta_box );
		}
	}

}

new ThemeRain_Meta_Boxes();
