<?php

/**
 * Class to register ThemeRain portfolio post type and custom taxonomy.
 */
final class ThemeRainPortfolio {

	/**
	 * Constructor.
	 */
	public function __construct() {

		// Plugin activation
		register_activation_hook( __FILE__, array( $this, 'plugin_activation' ) );

		// Init project post type
		add_action( 'init', array( $this, 'portfolio_init' ) );

		// Add thumbnail column
		add_filter( 'manage_edit-project_columns', array( $this, 'add_thumbnail_column' ), 10, 1 );
		add_action( 'manage_project_posts_custom_column', array( $this, 'display_thumbnail' ), 10, 1 );
	}

	/**
	 * Flush rewrite rules.
	 */
	public function plugin_activation() {
		$this->portfolio_init();
		flush_rewrite_rules();
	}

	/**
	 * Register post type and taxonomy.
	 */
	public function portfolio_init() {
		/**
		 * Register project post type.
		 */
		$labels = array(
			'name' => esc_html__( 'Projects', 'themerain-core' ),
			'singular_name' => esc_html__( 'Project', 'themerain-core' ),
			'add_new_item' => esc_html__( 'Add New Project', 'themerain-core' ),
			'edit_item' => esc_html__( 'Edit Project', 'themerain-core' ),
			'new_item' => esc_html__( 'New Project', 'themerain-core' ),
			'view_item' => esc_html__( 'View Project', 'themerain-core' ),
			'view_items' => esc_html__( 'View Projects', 'themerain-core' ),
			'search_items' => esc_html__( 'Search Projects', 'themerain-core' ),
			'not_found' => esc_html__( 'No projects found', 'themerain-core' ),
			'not_found_in_trash' => esc_html__( 'No projects found in Trash', 'themerain-core' ),
			'all_items' => esc_html__( 'All Projects', 'themerain-core' )
		);

		/**
		 * Filter project post type arguments.
		 */
		$args = array(
			'labels' => $labels,
			'public' => true,
			'show_in_rest' => true,
			'menu_position' => 5,
			'menu_icon' => 'dashicons-portfolio',
			'supports' => array( 'title', 'editor', 'thumbnail', 'excerpt', 'custom_fields' )
		);

		if ( get_option( 'themerain_portfolio_slug' ) ) {
			$args['rewrite']['slug'] = get_option( 'themerain_portfolio_slug' );
		}

		register_post_type( 'project', $args );

		/**
		 * Register project category taxonomy.
		 */
		$tax_labels = array(
			'name' => esc_html__( 'Project Categories', 'themerain-core' ),
			'menu_name' => esc_html__( 'Categories', 'themerain-core' )
		);

		/**
		 * Filter project category taxonomy arguments.
		 */
		$tax_args = array(
			'labels' => $tax_labels,
			'public' => false,
			'show_ui' => true,
			'show_in_rest' => true,
			'show_admin_column' => true
		);

		register_taxonomy( 'project-category', 'project', $tax_args );
	}

	/**
	 * Add thumbnail column.
	 */
	public function add_thumbnail_column( $columns ) {
		$column_thumb = array( 'thumbnail' => 'Thumbnail' );
		$columns = array_slice( $columns, 0, 2, true ) + $column_thumb + array_slice( $columns, 1, NULL, true );
		return $columns;
	}

	/**
	 * Display thumbnail.
	 */
	public function display_thumbnail( $column ) {
		global $post;
		switch ( $column ) {
			case 'thumbnail' :
				echo get_the_post_thumbnail( $post->ID, array( 35, 35 ) );
				break;
		}
	}
}

new ThemeRainPortfolio();
