<?php

function themerain_generate_vars( $selector, $var, $value ) {
	$return = '';

	$return = sprintf( '%s { %s: %s; } ', $selector, $var, $value );

	echo esc_attr( $return );
}

function themerain_get_custom_css() {
	$global_scheme = get_theme_mod( 'global_scheme' );
	$global_text_color = get_theme_mod( 'global_text_color' );
	$global_bg_color = get_theme_mod( 'global_bg_color' );
	$page_scheme = themerain_meta( 'page_color' );
	$page_text_color = sanitize_hex_color( themerain_meta( 'page_text_color' ) );
	$page_bg_color = sanitize_hex_color( themerain_meta( 'page_bg_color' ) );
	$hero_fixed = themerain_meta( 'hero_fixed' );
	$hero_scheme = themerain_meta( 'hero_scheme' );
	$hero_text_color = sanitize_hex_color( themerain_meta( 'hero_text_color' ) );
	$hero_bg_color = sanitize_hex_color( themerain_meta( 'hero_bg_color' ) );
	$hero_opacity = themerain_meta( 'hero_opacity' );
	$hero_opacity = ( $hero_opacity ) ? ( $hero_opacity * 0.01 ) : 0;
	$hero_opacity_scroll = themerain_meta( 'hero_opacity_scroll' );
	$hero_opacity_scroll = ( $hero_opacity_scroll ) ? ( $hero_opacity_scroll * 0.01 ) : 0;
	$primary_font = get_theme_mod( 'themerain_primary_font' );
	$secondary_font = get_theme_mod( 'themerain_secondary_font' );

	ob_start();

	echo '/* Custom CSS */ ';

	if ( 'dark' === $page_scheme || ( 'dark' === $global_scheme && 'light' !== $page_scheme ) ) {
		themerain_generate_vars( ':root', '--text-color', '#fff' );
		themerain_generate_vars( ':root', '--bg-color', '#000' );
		themerain_generate_vars( ':root', '--secondary-bg-color', 'rgba(255, 255, 255, .15)' );
	}

	if ( $page_text_color ) {
		themerain_generate_vars( ':root', '--text-color', $page_text_color );
	} elseif ( $global_text_color ) {
		themerain_generate_vars( ':root', '--text-color', $global_text_color );
	}

	if ( $page_bg_color ) {
		themerain_generate_vars( ':root', '--bg-color', $page_bg_color );
	} elseif ( $global_bg_color ) {
		themerain_generate_vars( ':root', '--bg-color', $global_bg_color );
	}

	if ( 'dark' === $hero_scheme && ! $hero_fixed ) {
		themerain_generate_vars( '.site-hero, .header--colored', '--text-color', '#fff' );
		themerain_generate_vars( '.site-hero, .header--colored', '--bg-color', '#000' );
	} elseif ( 'light' === $hero_scheme && ! $hero_fixed ) {
		themerain_generate_vars( '.site-hero, .header--colored', '--text-color', '#000' );
		themerain_generate_vars( '.site-hero, .header--colored', '--bg-color', '#fff' );
	}

	if ( $hero_text_color && ! $hero_fixed ) {
		themerain_generate_vars( '.site-hero, .header--colored', '--text-color', $hero_text_color );
	}

	if ( $hero_bg_color && ! $hero_fixed ) {
		themerain_generate_vars( '.site-hero', '--bg-color', $hero_bg_color );
	}

	themerain_generate_vars( '.site-hero', '--hero-opacity', $hero_opacity );

	if ( $hero_fixed ) {
		themerain_generate_vars( '.site-hero.has-scrolled', '--hero-opacity', $hero_opacity_scroll );
	}

	if ( 'default' !== $primary_font ) {
		themerain_generate_vars( ':root', '--font-primary', explode( ':', $primary_font )[0] );
	}

	if ( 'default' !== $secondary_font ) {
		themerain_generate_vars( ':root', '--font-secondary', explode( ':', $secondary_font )[0] );
	}

	return ob_get_clean();
}
