<?php

/**
 * Logo
 */
function themerain_logo() {
	$logo = get_theme_mod( 'themerain_logo' );
	$logo_light = get_theme_mod( 'themerain_logo_light' );
	$logo_svg = get_theme_mod( 'themerain_logo_svg' );
	$logo_width = get_theme_mod( 'themerain_logo_width' );
	$width = ( $logo_width ) ? ' style="max-width: ' . esc_attr( $logo_width ) . 'px;"' : '';
	$kses_defaults = wp_kses_allowed_html( 'post' );
	$svg_args = array(
		'svg' => array(
			'class' => true,
			'aria-hidden' => true,
			'aria-labelledby' => true,
			'role' => true,
			'xmlns' => true,
			'width' => true,
			'height' => true,
			'viewbox' => true,
		),
		'g' => array( 'fill' => true ),
		'title' => array( 'title' => true ),
		'path' => array( 'd' => true, 'fill' => true ),
	);
	$allowed = array_merge( $kses_defaults, $svg_args );

	echo '<div class="site-logo">';
		echo '<a href="' . esc_url( home_url( '/' ) ) . '" rel="home">';
			if ( $logo || $logo_light ) {
				if ( $logo ) echo '<img class="logo-dark" src="' . esc_url( $logo ) . '" alt="' . esc_attr( get_bloginfo( 'name', 'display' ) ) . '"' . $width . '>';
				if ( $logo_light ) echo '<img class="logo-light" src="' . esc_url( $logo_light ) . '" alt="' . esc_attr( get_bloginfo( 'name', 'display' ) ) . '"' . $width . '>';
			} elseif ( $logo_svg ) {
				echo wp_kses( $logo_svg, $allowed );
			} else {
				bloginfo( 'name' );
			}
		echo '</a>';
	echo '</div>';
}

/**
 * Menu
 */
function themerain_menu() {
	echo '<div class="site-menu-wrap">';
		if ( has_nav_menu( 'primary' ) ) {
			echo '<nav class="site-menu">';
				wp_nav_menu(
					array(
						'theme_location' => 'primary',
						'container' => false,
						'depth' => 2
					)
				);
			echo '</nav>';
		}

		themerain_social();
	echo '</div>';

	echo '<div class="menu-toggle"><span></span><span></span></div>';
}

/**
 * Social
 */
function themerain_social() {
	$twitter = get_theme_mod( 'themerain_social_twitter' );
	$facebook = get_theme_mod( 'themerain_social_facebook' );
	$youtube = get_theme_mod( 'themerain_social_youtube' );
	$instagram = get_theme_mod( 'themerain_social_instagram' );
	$behance = get_theme_mod( 'themerain_social_behance' );
	$dribbble = get_theme_mod( 'themerain_social_dribbble' );
	$vimeo = get_theme_mod( 'themerain_social_vimeo' );
	$telegram = get_theme_mod( 'social_telegram' );
	$tiktok = get_theme_mod( 'social_tiktok' );
	$pinterest = get_theme_mod( 'themerain_social_pinterest' );
	$linkedin = get_theme_mod( 'themerain_social_linkedin' );
	$vk = get_theme_mod( 'themerain_social_vk' );

	echo '<div class="site-social">';
		if ( $twitter ) echo '<a href="' . esc_url( $twitter ) . '" target="_blank">' . themerain_get_svg( 'twitter' ) . '</a>';
		if ( $facebook ) echo '<a href="' . esc_url( $facebook ) . '" target="_blank">' . themerain_get_svg( 'facebook' ) . '</a>';
		if ( $youtube ) echo '<a href="' . esc_url( $youtube ) . '" target="_blank">' . themerain_get_svg( 'youtube' ) . '</a>';
		if ( $instagram ) echo '<a href="' . esc_url( $instagram ) . '" target="_blank">' . themerain_get_svg( 'instagram' ) . '</a>';
		if ( $behance ) echo '<a href="' . esc_url( $behance ) . '" target="_blank">' . themerain_get_svg( 'behance' ) . '</a>';
		if ( $dribbble ) echo '<a href="' . esc_url( $dribbble ) . '" target="_blank">' . themerain_get_svg( 'dribbble' ) . '</a>';
		if ( $vimeo ) echo '<a href="' . esc_url( $vimeo ) . '" target="_blank">' . themerain_get_svg( 'vimeo' ) . '</a>';
		if ( $telegram ) echo '<a href="' . esc_url( $telegram ) . '" target="_blank">' . themerain_get_svg( 'telegram' ) . '</a>';
		if ( $tiktok ) echo '<a href="' . esc_url( $tiktok ) . '" target="_blank">' . themerain_get_svg( 'tiktok' ) . '</a>';
		if ( $pinterest ) echo '<a href="' . esc_url( $pinterest ) . '" target="_blank">' . themerain_get_svg( 'pinterest' ) . '</a>';
		if ( $linkedin ) echo '<a href="' . esc_url( $linkedin ) . '" target="_blank">' . themerain_get_svg( 'linkedin' ) . '</a>';
		if ( $vk ) echo '<a href="' . esc_url( $vk ) . '" target="_blank">' . themerain_get_svg( 'vk' ) . '</a>';
	echo '</div>';
}

/**
 * Footer
 */
function themerain_footer() {
	$portfolio_style = themerain_meta( 'portfolio_style' );
	$allowed = wp_kses_allowed_html( 'post' );

	if ( 'slider' === $portfolio_style || 'carousel' === $portfolio_style || is_404() ) {
		return;
	}
	?>
	<footer class="site-footer">
		<div class="footer-column">
			<?php echo wp_kses( wpautop( get_theme_mod( 'themerain_footer_1', '&copy; ' . date( 'Y ' ) . get_bloginfo( 'name' ) ) ), $allowed ); ?>
		</div>

		<div class="footer-column">
			<?php echo wp_kses( wpautop( get_theme_mod( 'themerain_footer_2' ) ), $allowed ); ?>
		</div>
	</footer>
	<?php
}

/**
 * Load more
 */
function themerain_loadmore( $type = '', $ppp = '', $cpage = '', $pages = '', $style = '' ) {
	$link = get_next_posts_link();

	if ( ( $pages > 1 ) && ( $cpage < $pages ) ) {
		echo '<div class="load-more" data-type="' . $type . '" data-ppp="' . $ppp . '" data-cpage="' . $cpage . '" data-pages="' . $pages . '" data-style="' . $style . '"><span>' . esc_html__( 'Load More', 'scena' ) . '</span></div>';
	}
}

/**
 * Post and Project Navigation
 */
function themerain_navigation() {
	$args = array(
		'posts_per_page' => 1,
		'order' => 'DESC'
	);

	$first = new WP_Query( $args );

	echo '<nav class="next-post">';
		echo '<p>' . esc_html__( 'Next Up', 'scena' ) . '</p>';

		if ( get_adjacent_post( false, '', true ) ) {
			previous_post_link( '<h4>%link</h4>', '%title' );
		} else {
			$first->the_post();
			echo '<h4><a href="' . esc_url( get_permalink() ) . '">' . esc_html( get_the_title() ) . '</a></h4>';
			wp_reset_postdata();
		}
	echo '</nav>';
}

/**
 * Portfolio Navigation
 */
function themerain_project_navigation( $postid ) {
	$portfolio_array = array();
	$unique_page     = themerain_meta( 'project_unique_page', $postid );
	$nav_title       = get_theme_mod( 'project_nav_title', esc_html__( 'Next Up', 'scena' ) );

	if ( $unique_page ) {
		$args = array(
			'post_type'      => 'project',
			'posts_per_page' => -1,
			'meta_key'       => 'themerain_project_unique_page',
			'meta_value'     => $unique_page,
		);
	} else {
		$args = array(
			'post_type'      => 'project',
			'posts_per_page' => -1
		);
	}

	$all_posts = new WP_Query( $args );

	while ( $all_posts->have_posts() ) :
		$all_posts->the_post();

		global $post;

		$project_link = themerain_meta( 'project_link_type', $post->ID );

		if ( ! ( $project_link && ( $project_link === 'image' || $project_link === 'video' || $project_link === 'url' || $project_link === 'none' ) ) ) {
			array_push( $portfolio_array, $post->ID);
		}
	endwhile;

	wp_reset_postdata();

	$current_index = array_search( $postid, $portfolio_array );

	if ( $current_index + 1 < sizeof( $portfolio_array ) ) {
		$next_postid = $portfolio_array[$current_index + 1];
	}

	if ( ! isset( $next_postid ) ) {
		$next_postid = $portfolio_array[0];
	}

	$output = '<nav class="next-post">';
		$output .= '<p>' . esc_html( $nav_title ) . '</p>';
		$output .= '<h4><a href="' . get_permalink( $next_postid ) . '">' . get_the_title( $next_postid ) . '</a></h4>';
	$output .= '</nav>';

	return $output;
}

/**
 * ThemeRain Image
 */
function themerain_get_image( $id ) {
	$html  = '';
	$attr  = array();
	$image = wp_get_attachment_image_src( $id, 'full' );

	if ( $image ) {
		$attr['data-src'] = $image[0];
		$attr['class']    = 'lazyload';
		$attr['alt']      = trim( strip_tags( get_post_meta( $id, '_wp_attachment_image_alt', true ) ) );

		$srcset = wp_get_attachment_image_srcset( $id, 'full' );
		if ( $srcset ) {
			$attr['data-srcset'] = $srcset;
		}

		$attr = array_map( 'esc_attr', $attr );

		$html = '<img';
		foreach ( $attr as $name => $value ) {
			$html .= " $name=" . '"' . $value . '"';
		}
		$html .= ' />';
	}

	return $html;
}
