<?php
get_header();

$style = get_theme_mod( 'blog_default_style', 'list' );
if ( is_archive() || is_search() ) {
	$style = get_theme_mod( 'archive_style', 'list' );
}

$archive_title = '';

if ( is_search() ) {
	$archive_title = sprintf(
		'%1$s %2$s',
		'<div>' . esc_html__( 'Search', 'scena' ) . '</div>',
		'&ldquo;' . get_search_query() . '&rdquo;'
	);
} elseif ( ! is_home() ) {
	$archive_title = get_the_archive_title();
}

if ( $archive_title ) {
	?>
	<header class="archive-header">
		<h1 class="archive-title"><?php echo wp_kses_post( $archive_title ); ?></h1>
	</header>
	<?php
}
?>

<div class="blog-area <?php echo esc_attr( $style ); ?>">
	<?php
	if ( have_posts() ) {

		while ( have_posts() ) :
			the_post();
			set_query_var( 'blog_style', $style );

			get_template_part( 'template-parts/content' );
		endwhile;

	} elseif ( is_search() ) {
		?>
		<div class="no-search-results">
			<h4><?php esc_html_e( 'No posts found.', 'scena' ); ?></h4>
			<a href="<?php echo esc_url( get_home_url( '/' ) ); ?>"><?php esc_html_e( '&larr; Back to home page', 'scena' ); ?></a>
		</div>
		<?php
	}
	?>
</div>

<?php
$ppp = get_option( 'posts_per_page' );
$cpage = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$pages = $wp_query->max_num_pages;

themerain_loadmore( 'post', $ppp, $cpage, $pages, $style );

get_footer();
