<?php
/**
 * Template Name: Portfolio
 */

get_header();

$style = themerain_meta( 'portfolio_style' );
$per_page = ( 'grid' === $style ) ? themerain_meta( 'portfolio_per_page' ) : -1;
$categories = themerain_meta( 'portfolio_categories' );
$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : ( get_query_var( 'page' ) ? get_query_var( 'page' ) : 1 );

$args = array(
	'post_type' => 'project',
	'posts_per_page' => $per_page,
	'paged' => $paged
);

if ( $categories ) {
	$args['tax_query'] = array( array( 'taxonomy' => 'project-category', 'terms' => $categories ) );
}

$query = new WP_Query( $args );
?>

<div class="portfolio-area <?php echo esc_attr( $style ); ?>">
	<?php
	if ( 'slider' === $style || 'carousel' === $style ) echo '<div class="swiper-container">';
	if ( 'slider' === $style || 'carousel' === $style ) echo '<div class="swiper-wrapper">';

	while ( $query->have_posts() ) :
		$query->the_post();
		set_query_var( 'portfolio_style', $style );

		if ( 'slider' === $style || 'carousel' === $style ) echo '<div class="swiper-slide">';
		get_template_part( 'template-parts/content', 'project' );
		if ( 'slider' === $style || 'carousel' === $style ) echo '</div>';
	endwhile;

	if ( 'slider' === $style || 'carousel' === $style ) echo '</div>';
	if ( 'carousel' === $style ) echo '<div class="swiper-scrollbar"></div>';
	if ( 'slider' === $style || 'carousel' === $style ) echo '</div>';
	?>
</div>

<?php
if ( 'grid' === $style ) {
	themerain_loadmore( 'project', $per_page, $paged, $query->max_num_pages, $style );
}

wp_reset_postdata();

get_footer();