<?php

class ThemeRain_Custom_Portfolio_Slug {

	function __construct() {
		add_action( 'admin_init', array( $this, 'init' ) );
	}

	function init() {
		// Update the custom slug
		if ( isset( $_POST['permalink_structure'] ) && isset( $_POST['themerain_portfolio_slug'] ) ) {
			$short_domain = wp_unslash( $_POST['themerain_portfolio_slug'] );
			update_option( 'themerain_portfolio_slug', $short_domain );
		}

		// Register a new section in the "permalink" page
		add_settings_section(
			'themerain_permalinks_section',
			'Portfolio',
			array( $this, 'callback' ),
			'permalink'
		);
	}

	// Section content
	function callback() {
		$slug = get_option( 'themerain_portfolio_slug' );
		?>

		<p>If you like, you may enter custom slug for your projects here. If you leave this blank the default will be used.</p>

		<table class="form-table">
			<tbody>
				<tr>
					<th><label for="themerain_portfolio_slug">Custom slug</label></th>
					<td><input type="text" id="themerain_portfolio_slug" name="themerain_portfolio_slug" value="<?php echo esc_attr( $slug ); ?>" class="regular-text code"></td>
				</tr>
			</tbody>
		</table>
		<?php
	}

}

new ThemeRain_Custom_Portfolio_Slug();
