<?php
/**
 * Plugin Name: ThemeRain Core
 * Description: Core functionalities for ThemeRain's themes.
 * Version: 1.0.4
 * Author: ThemeRain
 * Author URI: http://themeforest.net/user/themerain
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: themerain-core
 * Domain Path: /languages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * ThemeRain Core class.
 */
class ThemeRain_Core {

	/**
	 * ThemeRain Core instance.
	 */
	private static $instance = null;

	/**
	 * Returns ThemeRain Core instance.
	 */
	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->load();
	}

	/**
	 * Loads the plugin.
	 */
	private function load() {

		// Translation
		load_plugin_textdomain( 'themerain-core', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

		// Custom fonts
		require_once plugin_dir_path( __FILE__ ) . 'includes/fonts/class-themerain-fonts.php';

		// Portfolio
		require_once plugin_dir_path( __FILE__ ) . 'includes/portfolio/portfolio.php';
		require_once plugin_dir_path( __FILE__ ) . 'includes/portfolio/portfolio-custom-slug.php';

		// Blocks
		require_once plugin_dir_path( __FILE__ ) . 'includes/blocks/blocks.php';

		// Meta boxes
		require_once plugin_dir_path( __FILE__ ) . 'includes/meta-boxes/class-meta-boxes.php';
		require_once plugin_dir_path( __FILE__ ) . 'includes/meta-boxes/class-meta-box.php';

		// Customizer
		require_once plugin_dir_path( __FILE__ ) . 'includes/customizer/customizer.php';
	}
}

/**
 * Initializes the ThemeRain Core.
 */
ThemeRain_Core::get_instance();
