<?php

/**
 * Sets up theme defaults and registers support for various WordPress features
 */
function themerain_setup() {
	load_theme_textdomain( 'scena', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	register_nav_menu( 'primary', esc_html__( 'Primary Menu', 'scena' ) );
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'script',
			'style'
		)
	);
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'responsive-embeds' );
	add_theme_support( 'align-wide' );

	// Set content-width.
	global $content_width;
	if ( ! isset( $content_width ) ) {
		$content_width = 1400;
	}
}
add_action( 'after_setup_theme', 'themerain_setup' );

/**
 * Enqueues Scripts and Styles.
 */
function themerain_enqueue_scripts() {
	// Enqueue styles
	wp_enqueue_style( 'swiper', get_template_directory_uri() . '/assets/css/swiper.min.css', null );
	wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/assets/css/jquery.fancybox.min.css', null );
	wp_enqueue_style( 'themerain-style', get_stylesheet_uri(), array(), null );
	wp_add_inline_style( 'themerain-style', themerain_get_custom_css() );

	// Enqueue scripts
	wp_enqueue_script( 'lazysizes', get_theme_file_uri( '/assets/js/lazysizes.min.js' ), array(), null, true );
	wp_enqueue_script( 'ls-unveilhooks', get_theme_file_uri( '/assets/js/ls.unveilhooks.min.js' ), array(), null, true );
	wp_enqueue_script( 'comment-reply' );
	wp_enqueue_script( 'swup', get_theme_file_uri( '/assets/js/swup.min.js' ), array(), null, true );
	wp_enqueue_script( 'swup-body-class-plugin', get_theme_file_uri( '/assets/js/SwupBodyClassPlugin.min.js' ), array(), null, true );
	wp_enqueue_script( 'swup-head-plugin', get_theme_file_uri( '/assets/js/SwupHeadPlugin.min.js' ), array(), null, true );
	wp_enqueue_script( 'swup-scroll-plugin', get_theme_file_uri( '/assets/js/SwupScrollPlugin.min.js' ), array(), null, true );
	wp_enqueue_script( 'swiper', get_theme_file_uri( '/assets/js/swiper.min.js' ), array(), null, true );
	wp_enqueue_script( 'fancybox', get_theme_file_uri( '/assets/js/fancybox.min.js' ), array(), null, true );
	wp_enqueue_script( 'headroom', get_theme_file_uri( '/assets/js/headroom.min.js' ), array(), null, true );
	wp_enqueue_script( 'tweenmax', get_theme_file_uri( '/assets/js/tweenmax.min.js' ), array(), null, true );
	wp_enqueue_script( 'scrollmagic', get_theme_file_uri( '/assets/js/scrollmagic.min.js' ), array(), null, true );
	wp_enqueue_script( 'animation-gsap', get_theme_file_uri( '/assets/js/animation.gsap.js' ), array(), null, true );
	wp_enqueue_script( 'themerain-functions', get_theme_file_uri( '/assets/js/functions.js' ), array( 'jquery' ), null, true );

	// Localize scripts
	wp_localize_script( 'themerain-functions', 'themerain', array(
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'enable_ajax' => esc_attr( get_theme_mod( 'enable_ajax', 1 ) )
	) );
}
add_action( 'wp_enqueue_scripts', 'themerain_enqueue_scripts' );

/**
 * Enqueue Block Editor Styles.
 */
function themerain_block_editor_styles() {
	wp_enqueue_style( 'themerain-block-editor-styles', get_theme_file_uri( 'style-editor.css' ), array(), null, 'all' );
}
add_action( 'enqueue_block_editor_assets', 'themerain_block_editor_styles', 1, 1 );

/**
 * Block Editor Settings.
 */
function themerain_block_editor_settings() {
	// Block Editor Font Sizes.
	add_theme_support(
		'editor-font-sizes',
		array(
			array(
				'name'      => esc_html__( 'Normal', 'scena' ),
				'shortName' => 'S',
				'size'      => 14,
				'slug'      => 'normal',
			),
			array(
				'name'      => esc_html__( 'Medium', 'scena' ),
				'shortName' => 'M',
				'size'      => 18,
				'slug'      => 'medium',
			),
			array(
				'name'      => esc_html__( 'Large', 'scena' ),
				'shortName' => 'L',
				'size'      => 24,
				'slug'      => 'large',
			),
			array(
				'name'      => esc_html__( 'Huge', 'scena' ),
				'shortName' => 'XL',
				'size'      => 32,
				'slug'      => 'huge',
			)
		)
	);
}
add_action( 'after_setup_theme', 'themerain_block_editor_settings' );

/**
 * Add custom fonts.
 */
add_filter( 'themerain_fonts', function() {
	$fonts = array();

	$fonts[] = get_theme_mod( 'themerain_primary_font' );
	$fonts[] = get_theme_mod( 'themerain_secondary_font' );

	return $fonts;
} );

/**
 * Backwards compatibility for wp_body_open.
 */
if ( ! function_exists( 'wp_body_open' ) ) {
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
}

/**
 * REQUIRED FILES
 * Include required files.
 */
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/inc/template-functions.php';

// Customizer.
require get_template_directory() . '/inc/customizer.php';

// Meta boxes.
require get_template_directory() . '/inc/meta-boxes.php';

// SVG icons.
require get_template_directory() . '/inc/svg-icons.php';

// Custom CSS.
require get_template_directory() . '/inc/custom-css.php';

// Plugins.
require get_template_directory() . '/inc/classes/class-tgm-plugin-activation.php';
require get_template_directory() . '/inc/plugins.php';

// Demo import.
require get_template_directory() . '/inc/demo.php';
