<?php

/**
 * ThemeRain meta
 */
function themerain_meta( $field, $id = null ) {
	$field = 'themerain_' . $field;

	if ( $id ) {
		return get_post_meta( $id, $field, true );
	}	elseif ( is_home() && ! is_front_page() ) {
		return get_post_meta( get_option( 'page_for_posts' ), $field, true );
	} else {
		return get_post_meta( get_the_id(), $field, true );
	}
}

/**
 * Adds custom classes to the array of body classes.
 */
function themerain_body_classes( $classes ) {
	$portfolio_style = themerain_meta( 'portfolio_style' );

	if ( is_singular( 'post' ) || ( is_home() && is_front_page() ) || is_archive() || is_search() || 'covers' === $portfolio_style ) {
		$classes[] = 'no-hero';
	}

	if ( themerain_meta( 'hero_hide_title' ) ) {
		$classes[] = 'no-title';
	}

	if ( $portfolio_style && is_page_template( 'templates/template-portfolio.php' ) ) {
		$classes[] = 'portfolio-' . $portfolio_style;
	}

	$classes[] = 'page-' . themerain_meta( 'page_color' );

	if ( themerain_meta( 'hero_scheme' ) ) {
		$classes[] = 'hero-' . themerain_meta( 'hero_scheme' );
	}

	return $classes;
}
add_filter( 'body_class', 'themerain_body_classes' );

/**
 * Adds custom classes to the array of post classes.
 */
function themerain_post_classes( $classes ) {
	if ( get_the_content() ) {
		$classes[] = 'has-content';
	}

	if ( themerain_meta( 'post_featured' ) ) {
		$classes[] = 'featured';
	}

	return $classes;
}
add_filter( 'post_class', 'themerain_post_classes' );

/**
 * Replaces "[...]" (appended to automatically generated excerpts) with ...
 */
function themerain_excerpt_more( $more ) {
	return '';
}
add_filter( 'excerpt_more', 'themerain_excerpt_more' );

/**
 * Set custom excerpt length.
 */
function themerain_excerpt_length( $length ) {
	return 35;
}
add_filter( 'excerpt_length', 'themerain_excerpt_length', 999 );

/**
 * Modify the comment form input fields.
 */
function themerain_comment_form_fields( $fields ) {
	$fields['author'] = str_replace( 'name="author"', 'placeholder="' . esc_attr__( 'Name', 'scena' ) . '" name="author"', $fields['author'] );
	$fields['email'] = str_replace( 'name="email"', 'placeholder="' . esc_attr__( 'Email', 'scena' ) . '" name="email"', $fields['email'] );

	unset( $fields['url'] );
	unset( $fields['cookies'] );

	return $fields;
}
add_filter( 'comment_form_default_fields', 'themerain_comment_form_fields' );

/**
 * Customize the comment form comment field.
 */
function themerain_comment_form_field_comment( $fields ) {
	$fields['comment_field'] = str_replace( 'name="comment"', 'name="comment" rows="5"', $fields['comment_field'] );

	return $fields;
}
add_filter( 'comment_form_defaults', 'themerain_comment_form_field_comment' );

/**
 * Exclude pages and projects from search.
 */
function themerain_search_filter( $query ) {
	if ( ! is_admin() && $query->is_main_query() ) {
		if ( $query->is_search ) {
			$query->set( 'post_type', 'post' );
		}
	}
}
add_filter( 'pre_get_posts', 'themerain_search_filter' );

/**
 * Custom comment display.
 */
function themerain_list_comments( $comment, $args, $depth ) {
	?>
	<li <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ); ?> id="comment-<?php comment_ID() ?>">

	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
		<?php echo get_avatar( $comment, 160 ); ?>

		<div class="comment-content">
			<div class="comment-header">
				<b class="fn"><?php echo get_comment_author_link(); ?></b>
				<div class="comment-meta commentmetadata">
					<div><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>"><?php echo human_time_diff( strtotime( $comment->comment_date ), current_time( 'timestamp', 1 ) ) . ' ' . esc_html__( 'ago', 'scena' ); ?></a></div>
					<div class="reply"><?php comment_reply_link( array_merge( $args, array( 'add_below' => 'div-comment', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?></div>
				</div>
			</div>

			<?php if ( $comment->comment_approved == '0' ) { ?>
				<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'scena' ); ?></em><br/>
			<?php } ?>

			<div class="comment-text entry-content">
				<?php comment_text(); ?>
			</div>
		</div>
	</div>
	<?php
}

/**
 * Getting rid of archive "label".
 */
function themerain_archive_title( $title ) {
	if ( is_category() ) {
		$title = single_cat_title( '', false );
	} elseif ( is_tag() ) {
		$title = single_tag_title( '', false );
	} elseif ( is_author() ) {
		$title = get_the_author();
	}

	return $title;
}
add_filter( 'get_the_archive_title', 'themerain_archive_title' );

/**
 * Ajax load more.
 */
function themerain_loadmore_handler() {
	$type = $_POST['type'];
	$style = $_POST['style'];

	$args['post_type'] = $type;
	$args['posts_per_page'] = $_POST['ppp'];
	$args['paged'] = $_POST['cpage'] + 1;
	$args['post_status'] = 'publish';

	$query = new WP_Query( $args );

	while ( $query->have_posts() ) :
		$query->the_post();

		if ( $type === 'post' ) {
			set_query_var( 'blog_style', $style );
			get_template_part( 'template-parts/content' );
		} elseif ( $type === 'project' ) {
			set_query_var( 'portfolio_style', $style );
			get_template_part( 'template-parts/content', 'project' );
		}
	endwhile;

	die;
}
add_action( 'wp_ajax_themerain_loadmore', 'themerain_loadmore_handler' );
add_action( 'wp_ajax_nopriv_themerain_loadmore', 'themerain_loadmore_handler' );
