<?php
$portfolio_style = themerain_meta( 'portfolio_style' );

if ( is_singular( 'post' ) || ( is_home() && is_front_page() ) || is_archive() || is_search() || is_404() || 'slider' === $portfolio_style || 'carousel' === $portfolio_style || 'covers' === $portfolio_style ) {
	return;
}

$image = themerain_meta( 'hero_image' );
$video = themerain_meta( 'hero_video' );

$hero_classes = array();
$hero_classes[] = 'site-hero';
if ( themerain_meta( 'hero_full' ) ) {
	$hero_classes[] = 'height-full';
}
if ( themerain_meta( 'hero_fixed' ) ) {
	$hero_classes[] = 'style-fixed';
}
if ( ! themerain_meta( 'hero_fixed' ) ) {
	$hero_classes[] = 'parallax-img';
}
if ( 'full' === themerain_meta( 'hero_title_width' ) ) {
	$hero_classes[] = 'width-full';
}
if ( 'left' === themerain_meta( 'hero_title_alignment' ) ) {
	$hero_classes[] = 'aligment-left';
}
if ( 'right' === themerain_meta( 'hero_title_alignment' ) ) {
	$hero_classes[] = 'aligment-right';
}
if ( 'bottom' === themerain_meta( 'hero_title_position' ) ) {
	$hero_classes[] = 'position-bottom';
}
if ( ! themerain_meta( 'hero_hide_title' ) ) {
	$hero_classes[] = 'parallax-title';
	$hero_classes[] = 'title-' . themerain_meta( 'hero_title_size' );
}
$hero_classes = join( ' ', $hero_classes );
?>

<div class="<?php echo esc_attr( $hero_classes ); ?>">
	<?php get_template_part( 'template-parts/hero-title' ); ?>

	<?php if ( $image || $video ) { ?>
		<div class="hero-media">
			<?php if ( $video ) { ?>

				<video class="lazyload" src="<?php echo wp_get_attachment_url( $video ); ?>" data-poster="<?php echo wp_get_attachment_url( $image ); ?>" preload="none" muted loop playsinline autoplay>

			<?php } elseif ( $image ) { ?>

				<?php echo themerain_get_image( $image ); ?>

			<?php } ?>
		</div>
	<?php } ?>
</div>
