<?php
/**
 * Template Name: Blog
 */

get_header();

$style = themerain_meta( 'blog_style' );
$per_page = get_option( 'posts_per_page' );
$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : ( get_query_var( 'page' ) ? get_query_var( 'page' ) : 1 );

$args = array(
	'post_type' => 'post',
	'posts_per_page' => $per_page,
	'paged' => $paged
);

$query = new WP_Query( $args );
?>

<div class="blog-area <?php echo esc_attr( $style ); ?>">
	<?php
	while ( $query->have_posts() ) :
		$query->the_post();
		set_query_var( 'blog_style', $style );

		get_template_part( 'template-parts/content' );
	endwhile;
	?>
</div>

<?php
themerain_loadmore( 'post', $per_page, $paged, $query->max_num_pages, $style );

wp_reset_postdata();

get_footer();